function getCurrentTextView() {
    
    var currentWindow = NSApplication.sharedApplication().keyWindow();
    if (currentWindow) {
        var responder = currentWindow.firstResponder();
        if (responder.isKindOfClass(NSTextView.class())) {
            return responder;
        }
    }
        
    return null;
}

function installCommands() {
    var menuManager = mlkernel.menuManager();
    
    var item = menuManager.addTextCommandNamed_inSubMenu_withCommand("Link", "Markdown", function(textView) {
        
        var selectedRange = textView.selectedRange();
        if (selectedRange.length == 0) {
            textView.insertText_replacementRange("[](<# link #>)", selectedRange)
        }
        else {
            var selectedString = textView.textStorage().string().substringWithRange(selectedRange);
            var newString = "[" + selectedString + "](<# link #>)";
            textView.insertText_replacementRange(newString, selectedRange)
        }
        textView.setSelectedRange(NSMakeRange(selectedRange.location, 0));
        textView.selectNextPlaceholder(null);
    });
    
    item.setKeyEquivalent("k");
    
    
    
    item = menuManager.addTextCommandNamed_inSubMenu_withCommand("Insert Bullet", "Markdown", function(textView) {
        var selectedRange = textView.selectedRange();
        var paraRange = textView.selectionRangeForProposedRange_granularity(selectedRange, NSSelectByParagraph);
        
        var s = textView.string().substringWithRange(paraRange);
        
        if (s.hasPrefix("• ")) {
            textView.insertText_replacementRange("", NSMakeRange(paraRange.location, 2));
        }
        else {
            textView.insertText_replacementRange("• ", NSMakeRange(paraRange.location, 0));
        }
    });
    
    item.setKeyEquivalent("\\");
    
    
    
    item = menuManager.addTextCommandNamed_inSubMenu_withCommand("Copy as HTML", "Markdown", function(textView) {
        var selectedRange = textView.selectedRange();
        
        var paraRange = NSMakeRange(0, textView.textStorage().string().length())
        
        if (selectedRange.length > 0) {
            paraRange = textView.selectionRangeForProposedRange_granularity(selectedRange, NSSelectByParagraph);
        }
        
        var s = textView.string().substringWithRange(paraRange);
        
        s = s + "";
        
        m = require('marked.js');
        
        html = m(s);
        
        var pb = NSPasteboard.generalPasteboard();
        pb.clearContents();
        pb.addTypes_owner(["public.utf8-plain-text"], null);
        pb.setString_forType(html, "public.utf8-plain-text");
    
    });
    
    
}

function init() {
    installCommands();
}

function deinit() {

    
}


module.exports = {
    'init': init,
    'deinit': deinit,
}


