
var quickWriteTokens = null;
var scriptletTokens  = null;
var expressionTokens = null;


String.prototype.replaceAll = function(search, replacement) {
    var target = this;
    return target.split(search).join(replacement);
};



/////////////////////////////// end scriptlet functions



function scriptletReset() {
    quickWriteTokens = {};
    scriptletTokens  = {};
    expressionTokens = {};
}


function nextScriptletID(context) {
    var nextID = context['lastScriptletID'] + 1;
    var s = "$$THISISARANDOMSTRING$" + nextID + "$";
    context['lastScriptletID'] = nextID;
    return s;
}

function parseEpressions(context) {
    var s = context['s'];
    var start = s.indexOf("<%=");
    
    while (start >= 0) {
        
        var end = s.indexOf("%>", start + 1);
        
        if (end < 0) {
            console.log(s);
            console.log("Error reading scriptlet quick write - no ending tag ('%>)");
            break;
        }
        
        var m = s.substr(start + 3, end-(start + 3));
        var r = s.substr(end + "%>".length);
        var l = s.substr(0, start);
        
        var tok = nextScriptletID(context);
        
        expressionTokens[tok] = m;
        
        s = l + tok + r;
        
        start = s.indexOf("<%=");
    }
    
    context['s'] = s;
}

function parseScriptlets(context) {
    var s = context['s'];
    var start = s.indexOf("<%");
    
    while (start >= 0) {
        
        var end = s.indexOf("%>", start + 1);
        
        if (end < 0) {
            console.log(s);
            console.log("Error reading scriptlet quick write - no ending tag ('%>)");
            break;
        }
        
        var m = s.substr(start + 3, end-(start + 3));
        var r = s.substr(end + "%>".length);
        var l = s.substr(0, start);
        
        var tok = nextScriptletID(context);
        
        scriptletTokens[tok] = m;
        
        s = l + tok + r;
        
        start = s.indexOf("<%");
    }
    
    context['s'] = s;
}

function parseQuickWrites(context) {
    var s = context['s'];
    var start = s.indexOf("<%'");
    
    while (start >= 0) {
        
        var end = s.indexOf("'%>", start + 1);
        
        if (end < 0) {
            console.log(s);
            console.log("Error reading scriptlet quick write - no ending tag ('%>)");
            break;
        }
        
        var m = s.substr(start + 3, end-(start + 3));
        var r = s.substr(end + "'%>".length);
        var l = s.substr(0, start);
        
        var tok = nextScriptletID(context);
        
        quickWriteTokens[tok] = m;
        
        s = l + tok + r;
        
        start = s.indexOf("<%'");
    }
    
    context['s'] = s;
}

function stripComments(context) {
    
    var s = context['s'];
    
    var start = s.indexOf("<%--");
    
    while (start >= 0) {
        
        var end = s.indexOf("--%>", start + 1);
        
        if (end < 0) {
            console.log(s);
            console.log("Error reading scriptlet comments - no ending tag (--%>)");
            break;
        }
        
        var r = s.substr(end + "--%>".length);
        var l = s.substr(0, start);
        s = l + r;
        
        start = s.indexOf("<%--");
    }
    
    context['s'] = s;
}

function makeJSString(s) {
    
    s = s.replaceAll("\\", "\\\\");
    s = s.replaceAll("\"", "\\\"");
    s = s.replaceAll("'", "\\'");
    s = s.replaceAll("\r\n", "\n");
    s = s.replaceAll("\r", "\n");
    s = s.replaceAll("\n", "\\n\" + \n    \"");
    
    return s;
}

function wrapScriptlet(context) {
    
    var s = context['s'];
    
    s = makeJSString(s);
    
    for (tok in expressionTokens) {
        var wr = "\");\n    writer.write(" + expressionTokens[tok]  + ");\n    writer.write(\"";
        s = s.replace(tok, wr);
    };
    
    
    for (tok in scriptletTokens) {
        var wr = "\");\n" + scriptletTokens[tok]  + "\n    writer.write(\"";
        s = s.replace(tok, wr);
    };
    
    for (tok in quickWriteTokens) {
        var wr = "\");\n    writer.write(\"" + makeJSString(quickWriteTokens[tok])  + "\");\n    writer.write(\"";
        s = s.replace(tok, wr);
    };
    
    
    s = "function okscritpletmain(writer) {\n    writer.write(\"" + s + "\");\n}";
    
    context['s'] = s;
}

function scriptletTokenize(s) {
    
    // <%-- comment --%>
    // <%= expression %>
    // <%' plain text / html / no rtfified '%>
    // <% scriptlet %>
    
    var context = {}
    
    context['s'] = s;
    context['lastScriptletID'] = 0;
    
    stripComments(context);
    parseQuickWrites(context);
    parseEpressions(context);
    parseScriptlets(context);
    
    wrapScriptlet(context);
    
    return context['s'];
}

function scriptletWrapAndRun(s) {
    
    scriptletReset();
    
    s = scriptletTokenize(s);
    
    eval(s);
    
    var writer = {
        buffer:'',
        destination: function() {return 'web'},
    }
    
    writer.write = function(r) {
        this.buffer = this.buffer + r;
    };
    
    okscritpletmain(writer);
    
    return writer.buffer;
}

if (false) {
    
    var s = "starting 'line'\n" +
            "com<%-- comment --%>ment\n" +
            "\"com<%-- comment --%>ment\"\n" +
            "<%= 4+4 %> is \\8\\\n" +
            "pp<%' plain text / html / no rtfified '%>qq\n" +
            "<% writer.write('hello world'); %>\n" +
            "This is a line with nothing on it\n" +
            "<% writer.write('This is another scriptlet<br/>'); %>\n"

    
    console.log(scriptletWrapAndRun(s));

}



function init() {
    // installCommands();
}

function deinit() {

    
}


module.exports = {
    'init': init,
    'deinit': deinit,
    'scriptletWrapAndRun': scriptletWrapAndRun,
}

