function getCurrentTextView() {
    
    var currentWindow = NSApplication.sharedApplication().mainWindow();
    if (currentWindow) {
        var responder = currentWindow.firstResponder();
        if (responder.isKindOfClass(NSTextView.class())) {
            return responder;
        }
    }
        
    return null;
}

function getCurrentDocumentFileURL() {

    var currentWindow = NSApplication.sharedApplication().mainWindow();
    if (currentWindow) {
        var wc = currentWindow.windowController();
        if (wc) {
            var doc = wc.document();
            
            if (doc) {
                return doc.fileURL();
            }
        }
    }
        
    return null;
}

function installCommands() {
    var menuManager = mlkernel.menuManager();
    
    var item = menuManager.addTextCommandNamed_inSubMenu_withCommand("Insert Current Date YYYY.M.D", "Util", function(textView) {
        
        console.log("textView: " + textView)
        
        var wd = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        var d = new Date();
        var s = d.getFullYear() + "." + (d.getMonth() + 1) + "." + d.getDate() + " (" + wd[d.getDay()] + ")";
        
        if (textView) {
            var selectedRange = textView.selectedRange();
            textView.insertText_replacementRange(s, selectedRange)
        }
        else {
            LORuntimeExtras.keystroke(s);
            console.log("There is no text view! - gotta insert " + s);
        }
        
    });
    
    var item = menuManager.addTextCommandNamed_inSubMenu_withCommand("Lowercase", "Util", function(textView) {
        
        var selectedRange = textView.selectedRange();
        var s = textView.string().substringWithRange(selectedRange).lowercaseString();
        textView.insertText_replacementRange(s, selectedRange)
        
    });
    
    
    var item = menuManager.addMenuName_inSubMenu_withCommand("Restart Kernel", "Util", function(textView) {
        
        LOKernel.sharedKernel().restart();
        
    });
    
    item.setValidationHandler(function(responder) {
        return true;
    });
    
    
    
    menuManager.addMenuName_inSubMenu_withCommand("Reveal In Finder", "Util", function(textView) {
    
        var url = getCurrentDocumentFileURL();
        if (url) {
            NSWorkspace.sharedWorkspace().activateFileViewerSelectingURLs([url]);
        }
        
    }).setValidationHandler(function(responder) {
        return getCurrentDocumentFileURL() != null;
    });
    
}

function init() {
    installCommands();
}

function deinit() {

    
}


module.exports = {
    'init': init,
    'deinit': deinit,
}


